#include "CTransform.h"
#include <iostream>
#include <math.h>
#include <iomanip>

using namespace std;

// Konstruktor
CTransform::CTransform(){
    for(int x = 0; x < DIMENSION; x++) {
        for(int y = 0; y < DIMENSION; y++) {
            if(x != y)
                mat[x][y] = 0.0;
            else
                mat[x][y] = 1.0;
        }
    }
}

// Destruktor
CTransform::~CTransform() {
    //Da saemtliche Variablen auf dem stack erzeugt werden, ist der
    //Destruktor eigentlich redundant, daher wurde auf den copy constructor
    //und den copy assignment operator verzichtet ("rule of three")
}

// Einfache Ausgabemethode
void printMatrix(float matrix[4][4]) {
    for(int i = 0; i < 4; i++) {
        for(int j = 0; j < 4; j++) {
            cout << fixed << setprecision(1) << matrix[i][j] << " ";
        }
        cout << endl;
    }
}

// Rotation
void CTransform::rotate(Axis a, float degrees) {
    float rotateMatrix[DIMENSION][DIMENSION];
    //Initialisieren der Rotationsmatrix als Einheitsmatrix
    for(int x = 0; x < DIMENSION; x++) {
        for(int y = 0; y < DIMENSION; y++) {
            if(x != y)
                rotateMatrix[x][y] = 0.0;
            else
                rotateMatrix[x][y] = 1.0;
        }
    }

    //Vorsicht: Parameter der cos und sin Funktionen aus cmath/math.h
    //muessen in Bogenmass angegeben sein!
    float radians = degrees * M_PI/180.0;
    float sinValue = sin(radians);
    float cosValue = cos(radians);

    //Abhaengig von der Rotationsmatrix die Rotationsmatrix in die richtige
    //Form bringen
    switch(a) {
        case xAxis:
            rotateMatrix[1][1] = cosValue;
            rotateMatrix[1][2] = -sinValue;
            rotateMatrix[2][1] = sinValue;
            rotateMatrix[2][2] = cosValue;
            break;
        case yAxis:
            rotateMatrix[0][0] = cosValue;
            rotateMatrix[0][2] = sinValue;
            rotateMatrix[2][0] = -sinValue;
            rotateMatrix[2][2] = cosValue;
            break;
        case zAxis:
            rotateMatrix[0][0] = cosValue;
            rotateMatrix[0][1] = -sinValue;
            rotateMatrix[1][0] = sinValue;
            rotateMatrix[1][1] = cosValue;
            break;
    }
    updateMat(rotateMatrix);
}


// Translation
void CTransform::translate(Axis a, float distance) {
    float translationMatrix[DIMENSION][DIMENSION];
    //Initialisieren der TranslationsMatrix als Einheitsmatrix
    for(int x = 0; x < DIMENSION; x++) {
        for(int y = 0; y < DIMENSION; y++) {
            if(x != y)
                translationMatrix[x][y] = 0.0;
            else
                translationMatrix[x][y] = 1.0;
        }
    }
    //Abhaengig von der Translationsachse den Translationswert setzen
    switch(a) {
        case xAxis:
            translationMatrix[0][3] = distance;
            break;
        case yAxis:
            translationMatrix[1][3] = distance;
            break;
        case zAxis:
            translationMatrix[2][3] = distance;
            break;
    };
    //Multiplizieren mit mat (wobei Translationsmatrix links steht!)
    updateMat(translationMatrix);
}

// Skalierung
void CTransform::scale(Axis a, float factor) {
    float scaleMatrix[DIMENSION][DIMENSION];
    //Initialisieren der Skalierungsmatrix als Einheitsmatrix
    for(int x = 0; x < DIMENSION; x++) {
        for(int y = 0; y < DIMENSION; y++) {
            if(x != y)
                scaleMatrix[x][y] = 0.0;
            else
                scaleMatrix[x][y] = 1.0;
        }
    }
    //Abhaengig von der Skalierungsachse den Skalierungsfaktor setzen
    switch(a) {
        case xAxis:
            scaleMatrix[0][0] = factor;
            break;
        case yAxis:
            scaleMatrix[1][1] = factor;
            break;
        case zAxis:
            scaleMatrix[2][2] = factor;
            break;
    }
    //Multiplizieren mit mat (Wobei Skalierungsmatrix links steht!)
    updateMat(scaleMatrix);
}

// Vektor Transformation
float* CTransform::transform(float* vector){
    float* transformedVector = new float[4];

    //multiplizieren von mat und vector (eigentliches Transformieren)
    for(int i = 0; i < DIMENSION; i++) {
        float result = 0.0;
        for(int j = 0; j < DIMENSION; j++) {
            result = result + (mat[i][j] * vector[j]);
        }
        transformedVector[i] = result;
    }
    return transformedVector;
}

//Multipliziert neue Transformationsmatrizen von links mit mat, sodass
//Reihenfolge der scale(), rotate() und translate() Aufrufe
//auch der Reihenfolge der durchgefuehrten Transformationen entspricht
void CTransform::updateMat(float transMatrix[DIMENSION][DIMENSION]) {
    //Stellt buffer fuer die Multiplikation dar
    float newMat[DIMENSION][DIMENSION];

    //x. Zeile der transMatrix wird mit...
    for(int x = 0; x < DIMENSION; x++) {
        //y. Spalte von mat multipliziert um...
        for(int y = 0; y < DIMENSION; y++){
            //Wert von newMat[x][y] zu erhalten
            float result = 0.0;
            for(int k = 0; k < DIMENSION; k++) {
                result += (transMatrix[x][k] * mat[k][y]);
            }
            newMat[x][y] = result;
        }
    }
    //Werte von newMat in mat kopieren
    for(int x = 0; x < DIMENSION; x++) {
        for(int y = 0; y < DIMENSION; y++) {
            mat[x][y] = newMat[x][y];
        }
    }
}
